<?php
// Debug order processing
header('Content-Type: application/json');
session_start();

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    // Test database connection
    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "reviewprcom_db";
    
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        throw new Exception("Database connection failed: " . $conn->connect_error);
    }
    
    // Test if we can receive POST data
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    // Create a test order with received data or defaults
    $orderId = 'ORD-' . strtoupper(substr(md5(uniqid()), 0, 8));
    
    $sql = "INSERT INTO orders (order_id, product_name, price, quantity, total, customer_email, customer_name, review_location, reviews_per_day, customer_notes, status) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'pending')";
    
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    
    // Use received data or defaults - assign to variables for proper binding
    $product_name = $data['productName'] ?? "Debug Test Order";
    $price = (float)($data['price'] ?? 1.00);
    $quantity = (int)($data['quantity'] ?? 1);
    $total = (float)($data['total'] ?? ($price * $quantity));
    $email = $data['customerEmail'] ?? "debug@test.com";
    $customer_name = $data['customerName'] ?? "Test Customer";
    $review_location = $data['reviewLocation'] ?? "Test Business";
    $reviews_per_day = (int)($data['reviewsPerDay'] ?? 2);
    $customer_notes = $data['customerNotes'] ?? "Test order from futuristic checkout";
    
    // Bind parameters properly (variables must be assigned first for PHP references)
    $stmt->bind_param("ssdidsssiss", 
        $orderId, 
        $product_name, 
        $price, 
        $quantity, 
        $total, 
        $email, 
        $customer_name, 
        $review_location, 
        $reviews_per_day, 
        $customer_notes
    );
    
    if ($stmt->execute()) {
        echo json_encode([
            'success' => true,
            'message' => 'Debug order created successfully',
            'orderId' => $orderId,
            'received_data' => $data,
            'input_raw' => $input
        ]);
    } else {
        throw new Exception("Execute failed: " . $stmt->error);
    }
    
    $stmt->close();
    $conn->close();
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'debug_info' => [
            'received_data' => $data ?? null,
            'input_raw' => $input ?? null,
            'php_version' => PHP_VERSION,
            'mysql_error' => isset($conn) ? $conn->error : 'No connection'
        ]
    ]);
}
?>
