<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Futuristic Checkout - ReviewPR</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap');
        
        * { font-family: 'Inter', sans-serif; }
        
        .gradient-bg { 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            animation: gradientShift 8s ease-in-out infinite;
        }
        
        @keyframes gradientShift {
            0%, 100% { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
            50% { background: linear-gradient(135deg, #764ba2 0%, #667eea 100%); }
        }
        
        .glass-card {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.1);
        }
        
        .neon-input {
            background: rgba(255, 255, 255, 0.1);
            border: 2px solid rgba(255, 255, 255, 0.3);
            color: white;
            transition: all 0.3s ease;
        }
        
        .neon-input:focus {
            border-color: #fbbf24;
            box-shadow: 0 0 20px rgba(251, 191, 36, 0.5);
            background: rgba(255, 255, 255, 0.2);
        }
        
        .neon-input::placeholder {
            color: rgba(255, 255, 255, 0.7);
        }
        
        .btn-futuristic {
            background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
            border: none;
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
            color: #1f2937;
            font-weight: 600;
        }
        
        .btn-futuristic:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 35px rgba(251, 191, 36, 0.4);
        }
        
        .btn-futuristic::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.5s;
        }
        
        .btn-futuristic:hover::before {
            left: 100%;
        }
        
        .floating-animation {
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
        
        .pulse-glow {
            animation: pulseGlow 2s infinite;
        }
        
        @keyframes pulseGlow {
            0%, 100% { box-shadow: 0 0 20px rgba(251, 191, 36, 0.3); }
            50% { box-shadow: 0 0 40px rgba(251, 191, 36, 0.6); }
        }
        
        .success-modal {
            background: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(10px);
        }
        
        .loading-spinner {
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top: 3px solid #fbbf24;
            width: 24px;
            height: 24px;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body class="gradient-bg min-h-screen">
    <!-- Floating Navigation -->
    <nav class="glass-card fixed top-4 left-4 right-4 z-50 rounded-2xl">
        <div class="max-w-7xl mx-auto px-6">
            <div class="flex justify-between items-center h-16">
                <div class="flex items-center">
                    <a href="index.php" class="text-2xl font-bold text-white floating-animation">
                        <i class="fas fa-star mr-2 text-yellow-300"></i>ReviewPR
                    </a>
                </div>
                <div class="flex items-center space-x-6">
                    <a href="admin_dashboard.php" class="text-white hover:text-yellow-300 transition-colors">
                        <i class="fas fa-tachometer-alt mr-2"></i>Admin Panel
                    </a>
                    <a href="index.php" class="text-white hover:text-yellow-300 transition-colors">
                        <i class="fas fa-arrow-left mr-2"></i>Back to Home
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="pt-24 pb-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-6xl mx-auto">
            <!-- Header -->
            <div class="text-center mb-12 floating-animation">
                <h1 class="text-5xl font-bold text-white mb-4">
                    <i class="fas fa-rocket mr-4 text-yellow-300"></i>
                    Futuristic Checkout
                </h1>
                <p class="text-xl text-blue-100 max-w-2xl mx-auto">
                    Complete your order with our advanced review management system
                </p>
            </div>

            <!-- Checkout Form -->
            <div class="grid lg:grid-cols-2 gap-12">
                <!-- Order Summary Card -->
                <div class="glass-card rounded-3xl p-8 pulse-glow">
                    <h2 class="text-2xl font-bold text-white mb-6 flex items-center">
                        <i class="fas fa-shopping-cart mr-3 text-yellow-300"></i>
                        Order Summary
                    </h2>
                    
                    <div id="service-info" class="border-b border-white/20 pb-6 mb-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 id="service-name" class="text-xl font-semibold text-white">Loading...</h3>
                                <p class="text-blue-200">Professional review service</p>
                            </div>
                            <div class="text-right">
                                <div id="service-price" class="text-3xl font-bold text-yellow-300">$0.00</div>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-4">
                        <div class="flex justify-between items-center">
                            <span class="text-white">Quantity:</span>
                            <div class="flex items-center space-x-3">
                                <button onclick="updateQuantity(-1)" class="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center hover:bg-white/30 text-white transition-colors">
                                    <i class="fas fa-minus"></i>
                                </button>
                                <span id="quantity" class="text-xl font-bold text-yellow-300 w-8 text-center">1</span>
                                <button onclick="updateQuantity(1)" class="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center hover:bg-white/30 text-white transition-colors">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        
                        <div class="flex justify-between text-2xl font-bold border-t border-white/20 pt-4">
                            <span class="text-white">Total:</span>
                            <span id="total-price" class="text-yellow-300">$0.00</span>
                        </div>
                    </div>

                    <div class="mt-8 p-6 bg-white/10 rounded-2xl">
                        <div class="flex items-start">
                            <i class="fas fa-shield-alt text-yellow-300 text-xl mt-1 mr-4"></i>
                            <div class="text-white">
                                <p class="font-semibold mb-2">What's included:</p>
                                <ul class="space-y-1 text-sm text-blue-100">
                                    <li><i class="fas fa-check text-green-400 mr-2"></i>100% authentic reviews</li>
                                    <li><i class="fas fa-check text-green-400 mr-2"></i>Real user accounts</li>
                                    <li><i class="fas fa-check text-green-400 mr-2"></i>24/7 customer support</li>
                                    <li><i class="fas fa-check text-green-400 mr-2"></i>Money-back guarantee</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Customer Information Card -->
                <div class="glass-card rounded-3xl p-8">
                    <h2 class="text-2xl font-bold text-white mb-6 flex items-center">
                        <i class="fas fa-user-astronaut mr-3 text-yellow-300"></i>
                        Customer Information
                    </h2>
                    
                    <form id="checkoutForm" class="space-y-6">
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-white font-medium mb-2">
                                    <i class="fas fa-user mr-2"></i>Full Name
                                </label>
                                <input type="text" id="customer-name" class="neon-input w-full px-4 py-3 rounded-xl" placeholder="Enter your full name" required>
                            </div>
                            <div>
                                <label class="block text-white font-medium mb-2">
                                    <i class="fas fa-envelope mr-2"></i>Email Address
                                </label>
                                <input type="email" id="email" class="neon-input w-full px-4 py-3 rounded-xl" placeholder="your@email.com" required>
                            </div>
                        </div>

                        <div>
                            <label class="block text-white font-medium mb-2">
                                <i class="fas fa-map-marker-alt mr-2"></i>Review Location/Business
                            </label>
                            <input type="text" id="review-location" class="neon-input w-full px-4 py-3 rounded-xl" placeholder="Your business name or location" required>
                        </div>

                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-white font-medium mb-2">
                                    <i class="fas fa-calendar-day mr-2"></i>Reviews per Day
                                </label>
                                <select id="reviews-per-day" class="neon-input w-full px-4 py-3 rounded-xl">
                                    <option value="1">1 review per day</option>
                                    <option value="2" selected>2 reviews per day</option>
                                    <option value="3">3 reviews per day</option>
                                    <option value="5">5 reviews per day</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-white font-medium mb-2">
                                    <i class="fas fa-tag mr-2"></i>Promo Code
                                </label>
                                <input type="text" id="promo-code" class="neon-input w-full px-4 py-3 rounded-xl" placeholder="Enter promo code">
                            </div>
                        </div>

                        <div>
                            <label class="block text-white font-medium mb-2">
                                <i class="fas fa-comment-dots mr-2"></i>Special Instructions
                            </label>
                            <textarea id="notes" class="neon-input w-full px-4 py-3 rounded-xl" rows="4" placeholder="Any special requirements or notes..."></textarea>
                        </div>

                        <button type="submit" class="btn-futuristic w-full py-4 px-8 rounded-xl text-lg font-bold flex items-center justify-center">
                            <span id="btn-text">
                                <i class="fas fa-rocket mr-3"></i>
                                Complete Order
                            </span>
                            <div id="btn-loading" class="loading-spinner hidden"></div>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Success Modal -->
    <div id="successModal" class="fixed inset-0 success-modal flex items-center justify-center z-50 hidden">
        <div class="glass-card rounded-3xl p-8 max-w-md mx-4 text-center">
            <div class="text-6xl text-green-400 mb-4">
                <i class="fas fa-check-circle"></i>
            </div>
            <h3 class="text-2xl font-bold text-white mb-4">Order Successful!</h3>
            <p class="text-blue-100 mb-2">Your order has been placed successfully.</p>
            <p class="text-yellow-300 font-semibold mb-6" id="order-id-display">Order ID: #</p>
            <div class="space-y-3">
                <button onclick="window.location.href='admin_dashboard.php'" class="btn-futuristic w-full py-3 px-6 rounded-xl">
                    <i class="fas fa-tachometer-alt mr-2"></i>View in Admin Panel
                </button>
                <button onclick="window.location.href='index.php'" class="w-full py-3 px-6 rounded-xl bg-white/20 text-white hover:bg-white/30 transition-colors">
                    <i class="fas fa-home mr-2"></i>Back to Home
                </button>
            </div>
        </div>
    </div>

    <script>
        // Get URL parameters
        const urlParams = new URLSearchParams(window.location.search);
        const serviceName = urlParams.get('service') || 'Google Reviews Package';
        const servicePrice = parseFloat(urlParams.get('price')) || 49.99;
        
        // Initialize page
        document.getElementById('service-name').textContent = serviceName;
        document.getElementById('service-price').textContent = '$' + servicePrice.toFixed(2);
        updateTotal();
        
        function updateQuantity(change) {
            const quantityElement = document.getElementById('quantity');
            let quantity = parseInt(quantityElement.textContent);
            quantity = Math.max(1, quantity + change);
            quantityElement.textContent = quantity;
            updateTotal();
        }
        
        function updateTotal() {
            const quantity = parseInt(document.getElementById('quantity').textContent);
            const total = servicePrice * quantity;
            document.getElementById('total-price').textContent = '$' + total.toFixed(2);
        }
        
        // Form submission
        document.getElementById('checkoutForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Show loading state
            const btnText = document.getElementById('btn-text');
            const btnLoading = document.getElementById('btn-loading');
            btnText.classList.add('hidden');
            btnLoading.classList.remove('hidden');
            
            const quantity = parseInt(document.getElementById('quantity').textContent);
            const total = servicePrice * quantity;
            
            const orderData = {
                productId: 1,
                productName: serviceName,
                price: servicePrice,
                quantity: quantity,
                total: total,
                customerEmail: document.getElementById('email').value,
                customerName: document.getElementById('customer-name').value,
                reviewLocation: document.getElementById('review-location').value,
                reviewsPerDay: parseInt(document.getElementById('reviews-per-day').value),
                promoCode: document.getElementById('promo-code').value,
                customerNotes: document.getElementById('notes').value,
                fileName: '',
                fileLink: ''
            };
            
            fetch('debug_order.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(orderData)
            })
            .then(response => response.json())
            .then(data => {
                // Reset button state
                btnText.classList.remove('hidden');
                btnLoading.classList.add('hidden');
                
                if (data.success) {
                    // Show success modal
                    document.getElementById('order-id-display').textContent = 'Order ID: ' + data.orderId;
                    document.getElementById('successModal').classList.remove('hidden');
                } else {
                    alert('Error: ' + (data.error || 'Failed to place order'));
                }
            })
            .catch(error => {
                // Reset button state
                btnText.classList.remove('hidden');
                btnLoading.classList.add('hidden');
                
                console.error('Error:', error);
                alert('Network error. Please try again.');
            });
        });
    </script>
</body>
</html>
