<?php
// Reset admin user script
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "reviewprcom_db";

try {
    // Connect to MySQL server
    $conn = new mysqli($servername, $username, $password);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    // Create database
    $conn->query("CREATE DATABASE IF NOT EXISTS $dbname");
    $conn->select_db($dbname);
    
    // Create users table if it doesn't exist
    $conn->query("CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        email VARCHAR(100) NOT NULL,
        role ENUM('admin', 'staff') DEFAULT 'admin',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");
    
    // Check if admin user exists
    $check_admin = $conn->query("SELECT id FROM users WHERE username = 'admin'");
    
    $admin_password = 'admin123';
    $hashed_password = password_hash($admin_password, PASSWORD_DEFAULT);
    
    if ($check_admin->num_rows > 0) {
        // Update existing admin user
        $stmt = $conn->prepare("UPDATE users SET password = ?, email = ? WHERE username = 'admin'");
        $admin_email = 'admin@example.com';
        $stmt->bind_param("ss", $hashed_password, $admin_email);
        $action = "updated";
    } else {
        // Create new admin user
        $stmt = $conn->prepare("INSERT INTO users (username, password, email, role) VALUES (?, ?, ?, ?)");
        $admin_username = 'admin';
        $admin_email = 'admin@example.com';
        $admin_role = 'admin';
        $stmt->bind_param("ssss", $admin_username, $hashed_password, $admin_email, $admin_role);
        $action = "created";
    }
    
    if ($stmt->execute()) {
        echo "<h2>✅ Admin User " . ucfirst($action) . " Successfully!</h2>";
        echo "<p><strong>Username:</strong> admin</p>";
        echo "<p><strong>Password:</strong> admin123</p>";
        echo "<p>You can now login to the admin panel.</p>";
        
        // Verify the user was created correctly
        $verify = $conn->query("SELECT username, email FROM users WHERE username = 'admin'");
        if ($verify->num_rows > 0) {
            $user = $verify->fetch_assoc();
            echo "<p>✅ Verified: User '{$user['username']}' exists with email '{$user['email']}'</p>";
        }
        
        // Test password verification
        $test_query = $conn->query("SELECT password FROM users WHERE username = 'admin'");
        $test_user = $test_query->fetch_assoc();
        $password_test = password_verify('admin123', $test_user['password']);
        echo "<p>✅ Password verification test: " . ($password_test ? "PASSED" : "FAILED") . "</p>";
        
    } else {
        echo "<h2>❌ Error creating admin user</h2>";
        echo "<p>Error: " . $stmt->error . "</p>";
    }
    
    $stmt->close();
    $conn->close();
    
} catch (Exception $e) {
    echo "<h2>❌ Database Error</h2>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
    echo "<p>Please make sure XAMPP MySQL is running.</p>";
}
?>

<br><br>
<a href="admin_login.php" style="background: #3b82f6; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;">Go to Admin Login</a>
