<?php
// Test admin user creation
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "reviewprcom_db";

try {
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    echo "<h2>Database Test Results</h2>";
    
    // Check if users table exists
    $result = $conn->query("SHOW TABLES LIKE 'users'");
    if ($result->num_rows > 0) {
        echo "✅ Users table exists<br>";
        
        // Check users in the table
        $users = $conn->query("SELECT id, username, email, role, created_at FROM users");
        echo "<h3>Users in database:</h3>";
        if ($users->num_rows > 0) {
            echo "<table border='1'>";
            echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Role</th><th>Created</th></tr>";
            while($row = $users->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . $row['id'] . "</td>";
                echo "<td>" . $row['username'] . "</td>";
                echo "<td>" . $row['email'] . "</td>";
                echo "<td>" . $row['role'] . "</td>";
                echo "<td>" . $row['created_at'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
            
            // Test password verification
            $admin_check = $conn->query("SELECT password FROM users WHERE username = 'admin'");
            if ($admin_check->num_rows > 0) {
                $admin_data = $admin_check->fetch_assoc();
                $test_password = 'admin123';
                $is_valid = password_verify($test_password, $admin_data['password']);
                echo "<br><strong>Password test for 'admin123': " . ($is_valid ? "✅ VALID" : "❌ INVALID") . "</strong><br>";
                echo "Stored hash: " . substr($admin_data['password'], 0, 50) . "...<br>";
            }
        } else {
            echo "❌ No users found in table<br>";
        }
    } else {
        echo "❌ Users table does not exist<br>";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>

<br><br>
<a href="admin_login.php">← Back to Admin Login</a>
