<?php
// Simple database connection test
require_once 'config_no_headers.php';

echo "<h2>Database Connection Test</h2>";
echo "<p>Testing connection to: " . DB_HOST . " / " . DB_NAME . "</p>";
echo "<p>Using user: " . DB_USERNAME . "</p>";

try {
    $conn = getSecureConnection();

    if ($conn) {
        echo "<div style='color: green; font-weight: bold;'>✅ Database connection successful!</div>";

        // Test a simple query
        $result = $conn->query("SELECT 1 as test");
        if ($result) {
            $row = $result->fetch_assoc();
            echo "<div style='color: green;'>✅ Query test successful: " . $row['test'] . "</div>";
            $result->close();
        }

        $conn->close();
    }
} catch (Exception $e) {
    echo "<div style='color: red; font-weight: bold;'>❌ Database connection failed:</div>";
    echo "<div style='color: red;'>" . htmlspecialchars($e->getMessage()) . "</div>";
    echo "<p><strong>Make sure:</strong></p>";
    echo "<ul>";
    echo "<li>MySQL is running (start XAMPP)</li>";
    echo "<li>Database 'reviewprcom_db' exists</li>";
    echo "<li>User 'reviewpr_user' has correct password</li>";
    echo "<li>Run these SQL commands in phpMyAdmin:</li>";
    echo "</ul>";
    echo "<pre>";
    echo "CREATE USER IF NOT EXISTS 'reviewpr_user'@'localhost' IDENTIFIED BY 'your_mysql_root_password';\n";
    echo "GRANT ALL PRIVILEGES ON reviewprcom_db.* TO 'reviewpr_user'@'localhost';\n";
    echo "FLUSH PRIVILEGES;";
    echo "</pre>";
}

echo "<hr>";
echo "<p><a href='index.php'>← Back to main site</a></p>";
?>
