<?php
session_start();

// Check if admin is logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Check if required POST data is provided
if (!isset($_POST['order_id']) || !isset($_POST['status'])) {
    header("Location: dashboard.php");
    exit;
}

$order_id = intval($_POST['order_id']);
$new_status = trim($_POST['status']);

// Validate status
$valid_statuses = ['pending', 'processing', 'completed', 'cancelled'];
if (!in_array($new_status, $valid_statuses)) {
    header("Location: dashboard.php");
    exit;
}

include 'db.php';

// Update order status
$sql = "UPDATE orders SET status = ? WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $new_status, $order_id);

if ($stmt->execute()) {
    $stmt->close();
    $conn->close();
    // Redirect back to order details page
    header("Location: order_details.php?id=" . $order_id);
    exit;
} else {
    $stmt->close();
    $conn->close();
    // If update fails, redirect to dashboard
    header("Location: dashboard.php");
    exit;
}
?>
