<?php
// Redirect to new futuristic checkout
$service = $_GET['service'] ?? 'Google Reviews Package';
$price = $_GET['price'] ?? '49.99';
header("Location: simple-checkout.php?service=" . urlencode($service) . "&price=" . urlencode($price));
exit;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checkout - <?php echo htmlspecialchars($product['name']); ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/product-detail.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .checkout-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }

        .checkout-header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .product-summary {
            background: #f8f9fa;
            padding: 2rem;
            border-radius: 8px;
            margin-bottom: 2rem;
            display: flex;
            align-items: center;
            gap: 2rem;
        }

        .product-summary img {
            width: 150px;
            height: 150px;
            object-fit: cover;
            border-radius: 8px;
        }

        .product-summary-info h2 {
            margin: 0 0 1rem 0;
            color: #333;
        }

        .product-summary-info .price {
            font-size: 1.5rem;
            font-weight: bold;
            color: #e74c3c;
        }

        .checkout-form {
            background: white;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .form-row {
            display: flex;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: #333;
        }

        .form-control {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 1rem;
        }

        .form-control:focus {
            outline: none;
            border-color: #3498db;
            box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
        }

        .quantity-selector {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-top: 0.5rem;
        }

        .quantity-btn {
            width: 40px;
            height: 40px;
            border: 1px solid #ddd;
            background: white;
            border-radius: 4px;
            cursor: pointer;
            font-size: 1.2rem;
        }

        .quantity-btn:hover {
            background: #f8f9fa;
        }

        .quantity-input {
            width: 80px;
            text-align: center;
            padding: 0.5rem;
            border: 1px solid #ddd;
            border-radius: 4px;
        }

        .price-summary {
            background: #f8f9fa;
            padding: 1rem;
            border-radius: 4px;
            margin-top: 1rem;
        }

        .price-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 0.5rem;
        }

        .price-row.total {
            font-weight: bold;
            font-size: 1.2rem;
            border-top: 1px solid #ddd;
            padding-top: 0.5rem;
            margin-top: 0.5rem;
        }

        .btn-submit {
            background: #27ae60;
            color: white;
            padding: 1rem 2rem;
            border: none;
            border-radius: 4px;
            font-size: 1.1rem;
            cursor: pointer;
            width: 100%;
            margin-top: 1rem;
        }

        .btn-submit:hover {
            background: #219a52;
        }

        .btn-back {
            background: #95a5a6;
            color: white;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin-bottom: 1rem;
        }

        .btn-back:hover {
            background: #7f8c8d;
        }

        @media (max-width: 768px) {
            .product-summary {
                flex-direction: column;
                text-align: center;
            }

            .form-row {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="checkout-container">
        <div class="checkout-header">
            <h1>Checkout</h1>
            <a href="index.php" class="btn-back">
                <i class="fas fa-arrow-left"></i> Back to Products
            </a>
        </div>

        <div class="product-summary">
            <img src="<?php echo htmlspecialchars($product['image']); ?>" alt="<?php echo htmlspecialchars($product['name']); ?>">
            <div class="product-summary-info">
                <h2><?php echo htmlspecialchars($product['name']); ?></h2>
                <p><?php echo htmlspecialchars($product['description']); ?></p>
                <div class="price">$<?php echo number_format($product['price'], 2); ?></div>
                <div class="stock">Stock: <?php echo $product['stock']; ?> available</div>
            </div>
        </div>

        <form class="checkout-form" id="checkout-form">
            <input type="hidden" id="cart-data" value="<?php echo htmlspecialchars(json_encode($cartItems)); ?>">
            <input type="hidden" id="product-id" value="<?php echo $product['id']; ?>">
            <input type="hidden" id="product-name" value="<?php echo htmlspecialchars($product['name']); ?>">
            <input type="hidden" id="product-price" value="<?php echo $product['price']; ?>">

            <div class="form-row">
                <div class="form-group">
                    <label for="customer-email">Email Address *</label>
                    <input type="email" id="customer-email" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="promo-code">Promo Code (Optional)</label>
                    <input type="text" id="promo-code" class="form-control">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="review-location">Where to leave the reviews? *</label>
                    <input type="text" id="review-location" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="reviews-per-day">Reviews per day *</label>
                    <select id="reviews-per-day" class="form-control" required>
                        <option value="">Select reviews per day</option>
                        <option value="1">1 review per day</option>
                        <option value="2">2 reviews per day</option>
                        <option value="3">3 reviews per day</option>
                        <option value="4">4 reviews per day</option>
                        <option value="5">5 reviews per day</option>
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label>Upload file (TXT, CSV, DOC) or paste link</label>
                <div class="file-upload-wrapper">
                    <input type="file" id="review-file" class="file-upload" accept=".txt,.csv,.doc,.docx" style="display: none;">
                    <button type="button" class="btn-upload" onclick="document.getElementById('review-file').click()">
                        <i class="fas fa-upload"></i> Choose File
                    </button>
                    <span id="file-name" class="file-name">No file chosen</span>
                    <input type="text" id="file-link" class="form-control mt-2" placeholder="Or paste link here">
                </div>
            </div>

            <div class="form-group">
                <label>Quantity *</label>
                <div class="quantity-selector">
                    <button type="button" class="quantity-btn" onclick="updateQuantity('decrease')">-</button>
                    <input type="number" id="quantity" value="1" min="1" max="<?php echo $product['stock']; ?>" class="quantity-input">
                    <button type="button" class="quantity-btn" onclick="updateQuantity('increase')">+</button>
                </div>
            </div>

            <div class="price-summary">
                <div class="price-row">
                    <span>Price per review:</span>
                    <span id="price-per-review">$<?php echo number_format($product['price'], 2); ?></span>
                </div>
                <div class="price-row total">
                    <span>Total Price:</span>
                    <span id="total-price">$<?php echo number_format($product['price'], 2); ?></span>
                </div>
            </div>

            <div class="form-group">
                <label for="customer-notes">Special Instructions (Optional)</label>
                <textarea id="customer-notes" class="form-control" rows="3"></textarea>
            </div>

            <button type="submit" class="btn-submit">
                <i class="fas fa-shopping-cart"></i> Place Order
            </button>
        </form>
    </div>

    <!-- Order Success Modal -->
    <div id="order-success-modal" class="modal" style="display: none;">
        <div class="modal-content success-modal">
            <div class="success-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <h2>Order Placed Successfully!</h2>
            <p>Check your inbox for safe payment and your account manager details.</p>
            <p>Order ID: <span id="order-id"></span></p>
            <button onclick="closeSuccessModal()" class="btn-continue-shopping">Continue Shopping</button>
        </div>
    </div>

    <script src="../assets/js/script.js"></script>
    <script src="../assets/js/product-detail.js"></script>
    <script>
currentProduct
        const currentProduct = <?php echo json_encode($product); ?>;

        // Update quantity
        function updateQuantity(action) {
            const quantityInput = document.getElementById('quantity');
            const maxQuantity = <?php echo $product['stock']; ?>;
            let quantity = parseInt(quantityInput.value) || 1;

            if (action === 'increase') {
                if (quantity < maxQuantity) {
                    quantity++;
                } else {
                    alert(`Only ${maxQuantity} items available in stock`);
                    return;
                }
            } else if (action === 'decrease' && quantity > 1) {
                quantity--;
            }

            quantityInput.value = quantity;
            updateTotalPrice();
        }

        // Update total price
        function updateTotalPrice() {
            const quantity = parseInt(document.getElementById('quantity').value) || 1;
            const price = <?php echo $product['price']; ?>;
            const total = (price * quantity).toFixed(2);
            document.getElementById('total-price').textContent = `$${total}`;
        }

        // Handle file selection
        document.getElementById('review-file').addEventListener('change', function(e) {
            const fileName = e.target.files[0] ? e.target.files[0].name : 'No file chosen';
            document.getElementById('file-name').textContent = fileName;
        });

        // Handle form submission
        document.getElementById('checkout-form').addEventListener('submit', function(e) {
            e.preventDefault();

            // Check if we have cart data or single product
            const cartData = JSON.parse(document.getElementById('cart-data').value || '[]');
            const isCartCheckout = cartData.length > 0;

            // Collect form data
            const formData = {
                productId: document.getElementById('product-id').value,
                productName: document.getElementById('product-name').value,
                price: document.getElementById('product-price').value,
                quantity: document.getElementById('quantity').value,
                total: document.getElementById('total-price').textContent.replace('$', ''),
                customerEmail: document.getElementById('customer-email').value,
                reviewLocation: document.getElementById('review-location').value,
                promoCode: document.getElementById('promo-code').value,
                reviewsPerDay: document.getElementById('reviews-per-day').value,
                fileName: document.getElementById('review-file').files[0] ? document.getElementById('review-file').files[0].name : null,
                fileLink: document.getElementById('file-link').value || null,
                customerNotes: document.getElementById('customer-notes').value,
                isCartCheckout: isCartCheckout,
                cartData: cartData
            };

            // Send to server
            fetch('process_order.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo $_SESSION['csrf_token']; ?>'
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showOrderSuccess(data.orderId);
                } else {
                    alert(data.message || 'Failed to place order. Please try again.');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred. Please try again.');
            });
        });

        // Show order success modal
        function showOrderSuccess(orderId) {
            document.getElementById('order-id').textContent = orderId;
            document.getElementById('order-success-modal').style.display = 'block';
        }

        // Close success modal
        function closeSuccessModal() {
            document.getElementById('order-success-modal').style.display = 'none';
            window.location.href = 'index.php';
        }

        // Add some basic styling for the modal
        const modalStyle = document.createElement('style');
        modalStyle.textContent = `
            .modal {
                display: none;
                position: fixed;
                z-index: 1000;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.5);
                overflow-y: auto;
            }

            .modal-content {
                background-color: #fff;
                margin: 10% auto;
                padding: 2rem;
                border-radius: 8px;
                max-width: 500px;
                width: 90%;
                text-align: center;
            }

            .success-icon {
                font-size: 4rem;
                color: #27ae60;
                margin-bottom: 1rem;
            }

            .btn-continue-shopping {
                background: #3498db;
                color: white;
                padding: 0.75rem 2rem;
                border: none;
                border-radius: 4px;
                cursor: pointer;
                margin-top: 1rem;
            }

            .btn-continue-shopping:hover {
                background: #2980b9;
            }
        `;
        document.head.appendChild(modalStyle);
    </script>
</body>
</html>
