<?php
// Simple Configuration for ReviewPR
// No environment variables needed

// Security Configuration
session_start();

// Database Configuration (Simple)
define('DB_HOST', 'localhost');
define('DB_USERNAME', 'reviewprcom_user');
define('DB_PASSWORD', '2bVKrTrg?qjt');
define('DB_NAME', 'reviewprcom_db');
define('DB_CHARSET', 'utf8mb4');

// Application Configuration
define('APP_NAME', 'ReviewPR');
define('APP_ENV', 'development');
define('APP_DEBUG', true);

// Security headers
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: strict-origin-when-cross-origin');
header('Permissions-Policy: geolocation=(), microphone=(), camera=()');

// Content Security Policy
header("Content-Security-Policy: default-src 'self'; script-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com https://fonts.googleapis.com; style-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com https://fonts.googleapis.com; font-src 'self' https://fonts.gstatic.com https://cdnjs.cloudflare.com; img-src 'self' data: https: http:; connect-src 'self';");

// CSRF Token Generation
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Input sanitization function
function sanitizeInput($input) {
    if (is_array($input)) {
        return array_map('sanitizeInput', $input);
    }
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

// Validate email function
function validateEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

// Rate limiting (simple implementation)
function checkRateLimit($action, $limit = 10, $window = 60) {
    $key = $action . '_' . $_SERVER['REMOTE_ADDR'];
    $file = sys_get_temp_dir() . '/rate_limit_' . md5($key);

    $current_time = time();
    $requests = [];

    if (file_exists($file)) {
        $requests = json_decode(file_get_contents($file), true) ?: [];
    }

    // Remove old requests
    $requests = array_filter($requests, function($timestamp) use ($current_time, $window) {
        return ($current_time - $timestamp) < $window;
    });

    if (count($requests) >= $limit) {
        return false;
    }

    $requests[] = $current_time;
    file_put_contents($file, json_encode($requests));

    return true;
}

// Error handling
function handleError($message, $code = 500) {
    http_response_code($code);
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && strpos($_SERVER['CONTENT_TYPE'] ?? '', 'application/json') !== false) {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => $message]);
    } else {
        echo "<h1>Error $code</h1><p>" . htmlspecialchars($message) . "</p>";
    }
    exit;
}

// Performance settings
ini_set('zlib.output_compression', 'On');
ini_set('zlib.output_compression_level', '6');

// Database connection with error handling
function getSecureConnection() {
    try {
        $conn = new mysqli(DB_HOST, DB_USERNAME, DB_PASSWORD, DB_NAME);

        if ($conn->connect_error) {
            throw new Exception("Database connection failed");
        }

        $conn->set_charset(DB_CHARSET);
        return $conn;

    } catch (Exception $e) {
        error_log("Database connection error: " . $e->getMessage());
        handleError("Service temporarily unavailable", 503);
    }
}
?>
