-- ReviewPR Database Setup
-- Run this SQL script in phpMyAdmin or MySQL command line

-- Create database if not exists
CREATE DATABASE IF NOT EXISTS `reviewprcom_db` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE `reviewprcom_db`;

-- Users table for admin authentication
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `role` enum('admin','staff') NOT NULL DEFAULT 'staff',
  `last_login` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Products table (if not already exists)
CREATE TABLE IF NOT EXISTS `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `detailed_description` text DEFAULT NULL,
  `price` decimal(10,2) NOT NULL,
  `stock` int(11) NOT NULL DEFAULT 0,
  `image` varchar(255) DEFAULT NULL,
  `category` varchar(100) DEFAULT NULL,
  `position` int(11) DEFAULT 0,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `category` (`category`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Orders table
CREATE TABLE IF NOT EXISTS `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(20) NOT NULL,
  `customer_name` varchar(100) NOT NULL,
  `customer_email` varchar(100) NOT NULL,
  `customer_phone` varchar(20) DEFAULT NULL,
  `product_id` int(11) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `amount` decimal(10,2) NOT NULL,
  `status` enum('pending','processing','completed','cancelled','refunded') NOT NULL DEFAULT 'pending',
  `payment_status` enum('pending','paid','failed','refunded') NOT NULL DEFAULT 'pending',
  `payment_method` varchar(50) DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_number` (`order_number`),
  KEY `product_id` (`product_id`),
  KEY `customer_email` (`customer_email`),
  KEY `status` (`status`),
  KEY `payment_status` (`payment_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Order status history
CREATE TABLE IF NOT EXISTS `order_status_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `old_status` varchar(50) DEFAULT NULL,
  `new_status` varchar(50) NOT NULL,
  `notes` text DEFAULT NULL,
  `changed_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `changed_by` (`changed_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default admin user (username: admin, password: admin123)
INSERT INTO `users` (`username`, `password`, `email`, `role`) VALUES
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@example.com', 'admin')
ON DUPLICATE KEY UPDATE username = username;

-- Insert products from ff.sql export
INSERT INTO `products` (`id`, `name`, `price`, `category`, `image`, `description`, `detailed_description`, `stock`, `position`, `created_at`, `updated_at`) VALUES
(1, 'G2 Reviews', 21.99, 'Positive Saas Reviews', 'http://reviewpr.com/img/G2.R.jpg', 'High-quality and Authentic User Post. No IP , No Proxy', 'Experience superior sound quality with our premium wireless headphones. Featuring advanced noise cancellation technology, these headphones deliver crystal-clear audio with deep bass and crisp highs. The ergonomic design ensures comfortable wearing for extended periods, while the long-lasting battery provides up to 30 hours of playback. Perfect for music lovers, commuters, and professionals who demand the best in audio technology. Key features include Bluetooth 5.0 connectivity, quick charge capability, and premium leather padding for ultimate comfort.', 250, 1, '2025-10-06 11:56:36', '2025-10-09 12:43:48'),
(5, 'Sitejabber Reviews', 3.00, 'Positive Saas Reviews', 'http://reviewpr.com/img/SitejabberRRR.png', 'The Best Premium-Quality Sitejabber Reviews', '', 5000, 21, '2025-10-06 11:56:36', '2025-10-09 12:31:14'),
(17, 'Trustpilot Reviews', 2.10, 'Positive Saas Reviews', 'http://reviewpr.com/img/TrustpilotR.png', '5 Star TrustPilot Reviews  - Genuine and Top Quality ', 'Everyone is trying to save money as one never knows what may happen next. With this in mind, you will want to buy cheap Trustpilot reviews. We have a range of packages at very competitive rates. It doesn\'t matter what your budget is, we will be able to help you! If you want to know how to increase Trustpilot reviews, don\'t hesitate and contact us today. A member of our team of review specialists will contact you so that we can work on a package to meet your business\'s needs before you can blink your eyes! ', 5000, 2, '2025-10-07 06:01:19', '2025-10-09 12:44:04'),
(18, 'Google Reviews', 3.50, 'Positive Saas Reviews', 'http://reviewpr.com/img/GoogleR.png', 'The Great Place to Buy Google Positive Reviews', 'If you want to know the ideal site to obtain Google reviews, you have come to the right place. Our business employs a team of dedicated professionals from many different geographical regions and areas of expertise that will help you to obtain Google reviews.', 5000, 47, '2025-10-07 06:57:09', '2025-10-09 12:37:17'),
(19, 'Clutch.co Reviews', 19.99, 'Positive Saas Reviews', 'http://reviewpr.com/img/ClutchR.png', 'Buy quality Clutch.co Reviews', 'You can purchase good clutch. co reviews from credible sites such as ReviewPR. There are already more sites selling reviews out there. But not all sites selling reviews are authentic or can provide quality reviews as they promise. If you buy reviews easily from trusted sites, you will be able to find and buy Clutch.co Reviews for cheap and bulk. These are organic reviews that will be added to your clutch profile upon the completion of your purchase.\r\n\r\nWe consider ReviewPR to be one of the best sites to get quality Clutch - B2B ratings and reviews ratings from. They have good customer service that will fix (and are available to fix) any review purchase issues immediately. They also guarantee 100 quality with their reviews - which is something nearly impossible to obtain from other sites!', 5000, 4, '2025-10-07 07:03:18', '2025-10-09 12:44:21'),
(20, 'Reviews.io Reviews', 3.99, 'Positive Saas Reviews', 'http://reviewpr.com/img/Reviews.oiR.png', 'Best Place to Buy Reviews.io Reviews ', 'In order to help you, we need three things to provide the appropriate agency services to you.\r\n\r\n1. We need to understand your business. When we know your target market, we will understand the type of service required as well as the feedback from potential customers. The ratings and phraseology will be key.\r\n\r\n2. We need you to provide a listing of your company, so we can all dissect what it means to reach your potential customers about your service. It will be less demanding and of little concern for us to gather your reviews on Reviews.Io if we know were all your product listings are, as well as customer listings in the past few months, a year, or so.\r\n\r\n3. Lastly, we need you to trust our system and process. It will not take more than a week or two to improve your conversion rate and get you selling and making your money back. You can always contact customer service for your queries.\r\n\r\nWe know what you need, as we have had them before. We know how to answer them, as we were all there at one time for our business. Take a breath and take each small step, we are here to support and help in every way we can.', 5000, 20, '2025-10-07 07:05:51', '2025-10-09 12:45:58'),
(21, 'Airbnb Reviews', 8.00, 'Positive Saas Reviews', 'http://reviewpr.com/img/AirbanR.png', 'Buy quality Airbnb Reviews', 'We provide true Airbnb reviews, and we may provide you one or a few positive, negative or sometimes zero reviews. But we charge you solely for the positive. From that, you can infer the credibility and sincerity of our service. We continue to wait for positive reviews, as we have no ability to convince honest users to change their comments online. A customer was at your Airbnb service, and they write the reviews regarding their experience. It doesn\'t come from a fabricated story.', 5000, 26, '2025-10-07 07:08:27', '2025-10-09 12:32:15'),
(22, 'Facebook Reviews', 1.10, 'Positive Saas Reviews', 'http://reviewpr.com/img/FacebookR.png', 'Buy Facebook Positive Reviews - FAQ ', 'Trust us when we say that your business needs authentic positive Facebook reviews. If you\'re still unsure, we\'ve created a special Question and Answer section to answer some of your questions.', 5000, 35, '2025-10-07 07:13:07', '2025-10-09 12:34:00'),
(23, 'Google Play Reviews', 3.00, 'Positive Saas Reviews', 'http://reviewpr.com/img/GooglePlayR.png', 'The Best Online Source of Premium-Quality Android Reviews', 'Locating the most suitable website to buy Android reviews can be overwhelming. However, there is no need for concern because ReviewPR is here to help you best.\r\n\r\nIf you are new to ReviewPR, where you can buy Android application reviews, you will not be disappointed by this wonderful online establishment. It is rank one when searching for high-quality social media accounts, including Twitter, Instagram, or Facebook.\r\n\r\nIn addition, ReviewPR has more products to offer. In addition to buying Android reviews online, this online services provider allows you to purchase an apparent two high-quality products:\r\n\r\n1)  QUALITY GOOGLE PLAY REVIEWS\r\n\r\nThis product offers real Android reviews with authentic users. In addition, the texts are high-quality and relevant and available in English. The Quality Google Play Reviews supplied by ReviewPR provides a five-star rating.\r\n\r\nYou will experience instant delivery, 100-per cent security, and customer service available 24/7. Are you looking to buy cheap Android reviews? The Quality Google Play Reviews is a great option for as little as US $4.99.\r\n\r\n2)  CUSTOM GOOGLE PLAY REVIEWS\r\n\r\nReviewPR\'s Custom Google Play Reviews are composed of Android application reviews by real users, very similar to their Quality Google Play Reviews content. These discussions are high quality.', 5000, 10, '2025-10-07 07:20:56', '2025-10-09 12:27:44'),
(24, 'Houzz Reviews', 4.00, 'Positive Saas Reviews', 'http://reviewpr.com/img/HouzzR.png', 'Buy Houzz Reviews', 'There is no doubt that reviews are very much important for the success of every business. To make sure you have an overall successful journey in the long run as well as to better leverage your online presence is to have some positive reviews from the clients that love you. You can buy positive Houzz Reviews cheap from ReviewPR. The customers can use any platform to add their opinion, across the different social media platforms, but the reviews on Houzz are a lot more important than the reviews on most platforms. As professionals, the positive reviews of customers just carry a lot of weight and are the most important things. Just remember, it\'s not the photos or a completed project, it\'s the good reviews that are most important to Houzz. Hence, it becomes relevant to buy Houzz Reviews here.', 5000, 29, '2025-10-07 07:24:54', '2025-10-09 12:32:49'),
(26, 'GoodFirms Reviews', 19.99, 'Positive Saas Reviews', 'http://reviewpr.com/img/GoodFirmsR.png', 'Buy GoodFirms Reviews', 'Purchasing reviews has been a practice that has been done for a long time. Many companies, especially new ones that need to move faster, will find these purchases easier and more appealing than attempting to go through the organic processes. Today anyone can purchase quality GoodFirms reviews from reliable sources. You will want to avoid buying reviews from new sources or sources without enough positive reviews. Most of the spammy or fake reviews come from sources like these. \r\nreviewpr is one of the best trusted sources and a social media service where you can buy GoodFirms reviews from. Many people find reviewpr attractive because of their great support system that will resolve any issues quickly. They offer high quality organic reviews as well if you\'re concerned about getting banned. reviewpr also provides reviews for a fair rate compared to other sites. For instance, GoodFirms reviews are listed as $14.99.  They also have a good option to buy GoodFirms Reviews cheap and in quantity.', 5000, 5, '2025-10-07 07:25:15', '2025-10-09 12:44:29'),
(28, 'Glassdoor Reviews', 6.99, 'Positive Saas Reviews', 'http://reviewpr.com/img/GlassdoorR.png', 'Buy Glassdoor Reviews for your Company - Real & Fast ', 'Numerous websites provide the possibility to buy cheap Glassdoor reviews. You will want to invest in these sites only after you do your due diligence to vet their services. You will want to check what productive services they are offering for your investment.', 5000, 17, '2025-10-07 07:29:25', '2025-10-09 12:45:43'),
(29, 'Wordpress Reviews', 3.50, 'Positive Saas Reviews', 'http://reviewpr.com/img/WordpressR.png', 'The Best Premium-Quality Wordpress Reviews\r\n', 'We assure that authentic and honest reviews will be provided by active users who have used our services. All reviews we receive will be based on actual user experiences, and they will be valid. All reviews supplied will be non-incentivized and so can contain both positive and negative reviews. Since they are unbeatable real reviews, you may get eight positives and two negatives, but there is no way to manipulate those actual real reviews. Accordingly, you will pay for the positive reviews only, and the negatives will be held for additional positive reviews. Our providers run advertisements across social media and encourage prospects, through sample reviews (via email widget), to write reviews of their experience with our products. ', 5000, 52, '2025-10-07 07:32:26', '2025-10-09 12:38:19'),
(30, 'BBB Reviews', 6.00, 'Positive Saas Reviews', 'http://reviewpr.com/img/BBBR.png', 'Why Buy BBB Reviews', 'Acquiring BBB reviews can facilitate growth to your business\'s reputation ultimately leading to higher potential customer acquisition. BBB reviews can increase your popularity in a community that has an emphasis on the reviews of other consumers. In addition to a boost in popularity, when you acquire BBB reviews, you also increase your legitimacy and allow your company to ride back on the success of the platform\'s popularity and credibility.\r\n\r\nWhen you buy BBB reviews, there\'s nowhere to go but up for your business. Being a BBB Business gives users more access to finding out about:\r\n\r\n.When BBB users stumble upon your business, they will want to investigate further. Users will seek out your business as they will know exactly what products you have on offer, and positive reviews will encourage them in your direction, leading to more traffic for your site, and, ultimately more, traffic in the long run.\r\n.BBB reviews can also let other users find out about the service your business provides, and that is the same for you if you aren\'t selling products. This leads to more users wanting to check out your site, find out about your services, and will likely check them out, and along with them they will bring extra traffic to your site.\r\n.BBB reviews can lead other users to learn what you offer, and then similarly to not being a product seller. More users will be interested in looking up your site, determining what you have to offer, and trying it. In doing so, they will generate additional traffic for your site.\r\n.Increasing user traffic will want to verify the BBB reviews are legitimate. It means they\'re going to buy products and/or services from you to experience it for themselves. Additionally, you will have new users who will start reviewing your business and leaving feedback. \r\n.Eventually, more exposure combined with traffic from your s...[343 bytes truncated]', 5000, 1, '2025-10-07 07:34:48', '2025-10-09 12:32:32'),
(31, 'Chrome Extension Reviews', 4.99, 'Positive Saas Reviews', 'http://reviewpr.com/img/ChromeR.png', 'A Top Assisted Purchase Chrome Extension Review', 'Get visibility with a quality, human written review done by a professional product reviewer. We will test or analyze your extension, note the important features, pros, and unique value, and write a thoughtful, SEO-optimized review that will drive users to you and convert sales.\r\nGreat for Chrome Web Store listings, your website, or marketing campaigns.', 5000, 13, '2025-10-07 07:38:07', '2025-10-09 12:45:29'),
(32, 'Amazon Reviews', 10.00, 'Positive Saas Reviews', 'http://reviewpr.com/img/AmazonR.png', 'Can You Purchase Exclusive Reviews?', 'ReviewPR has an array of choices when it comes to Amazon reviews. As the seller, it is your decision on which reviews to have to build your profile or your product rating. Sellers should beware and read specifics on the guidelines on how to ensure that purchased reviews are utilized for your account so your account does not get restricted or banned. These reviews do help services or products, but can always counteract the goal you are attempting to achieve with the reviews.\r\n', 5000, 41, '2025-10-07 07:40:46', '2025-10-09 12:35:03'),
(33, 'Producthunt Reviews', 21.50, 'Positive Saas Reviews', 'http://reviewpr.com/img/ProducthuntR.png', 'Buy Positive Product Hunt Reviews', 'If you\'re using Product Hunt to promote your business, positive reviews count. Products and services with a lot of positive reviews get noticed by the press. Good reviews are ways to develop a big audience. Some positive reviews that are too good to be true are sometimes generating skepticism from consumers.\r\n\r\nIt is important to find a reputable company to provide some good quality reviews from users. Consumers today can tell if a review is fake in a heartbeat. Usually, a few negative reviews provide reliability to positive reviews and are the reason some companies buy a few negative reviews as well. Having more examples of positive reviews will help you earn more sales.', 5000, 8, '2025-10-07 07:46:29', '2025-10-09 12:27:11'),
(34, 'Booking Reviews', 10.00, 'Positive Saas Reviews', 'http://reviewpr.com/img/BookingR.png', 'Buy Cheap Booking Reviews ', 'At ReviewPR, you can purchase Booking reviews starting from $49.99. Most of our regular customers appreciate that our services justify the price tag and that we are not ridiculously priced, meaning we are cost-affordable and our quality of service matches the cost. We do not say we are providing the cheaper options, however, we always say we do not provide anything but legitimate options, so that our customers never have to deal with any potential trouble in the future.', 5000, 25, '2025-10-07 07:47:27', '2025-10-09 12:32:05'),
(35, 'Reddit Posts / Comments', 4.00, 'Positive Saas Reviews', 'http://reviewpr.com/img/Redit.R.png', 'Authentic Reddit Comments & Posts – Genuine Engagement & Intelligent Promotion', 'A true, insightful Reddit post or comment for you that cultivates interest and credibility for your product/brand/idea. \r\nWe create posts that fit into the Reddit tone and community culture seamlessly - no spam, no bots - just great posts that can be used for:\r\n✅Product promotions\r\n✅SaaS/App discussions\r\n✅Community engagement\r\n✅Gain organic visibility & grow brand presence ', 5000, 15, '2025-10-07 07:48:58', '2025-10-09 12:28:39'),
(36, 'Etsy Reviews', 4.50, 'Positive Saas Reviews', 'http://reviewpr.com/img/EtsyR.png', 'Buy Safe Etsy Reviews', 'Every review we provide is secure and safe. We assure you, we do not receive your credential information, and all transactions will show up on your dashboard. We can guarantee that the product reviews are from real people who have used your product. This is our way of delivering high-quality and quality reviews to our partners.\r\n\r\nSome marketing agencies will claim that they are safe and trustworthy, but they only get reviews from bot traffic. This will result in poor conversions and untrustworthy feedback.', 5000, 45, '2025-10-07 07:50:22', '2025-10-09 12:36:11'),
(37, 'YouTube Comment Reviews', 1.30, 'Positive Saas Reviews', 'http://reviewpr.com/img/YoutubeR.png', 'Buy quality YouTube reviews ', 'Enhance the credibility and interaction of your YouTube video by obtaining authentic, human-written comment reviews. \r\nWe generate natural conversational-style comments that promote your product, app, or service in a credible and organic manner with no bots or spam.', 5000, 36, '2025-10-07 07:53:21', '2025-10-09 12:34:12'),
(38, 'TripAdvisor Positive Reviews', 3.99, 'Positive Saas Reviews', 'http://reviewpr.com/img/TripadvisorR.png', 'Increase TripAdvisor Positive Reviews ', 'Research suggests that over 70% of hotel bookings occur on the basis of positive online reviews, specifically those on TripAdvisor. So, your chances of being chosen as the hotel of choice more than triples if you buy TripAdvisor reviews from us. Whether consciously or unconsciously, the human mind is drawn towards that which others have approved. This is why we would like to show you how to increase TripAdvisor reviews for your business.\r\n', 5000, 24, '2025-10-07 07:54:49', '2025-10-09 12:46:17'),
(39, 'Instagram Reviews', 1.25, 'Positive Saas Reviews', 'http://reviewpr.com/img/InstagramR.png', 'Professional Instagram Reviews - Real, Engaging & Brand-Focused\r\n', 'Amp up your Instagram with real, human-written reviews that build trust and help you engage real people. \r\nWe write original Instagram captions, comments or mini-reviews in your brand\'s voice - no bots, no fake engagement.\r\n\r\n\r\nPerfect for: \r\n✅ Product / Service Promotions \r\n✅ Influencer & Brand Campaigns \r\n✅ Real Social Proof & Authenticity', 5000, 37, '2025-10-07 07:57:07', '2025-10-09 12:34:24'),
(40, 'Promotion On Forums', 10.00, 'Positive Saas Reviews', 'http://reviewpr.com/img/PromotionRN.png', 'Forum Promotion – Genuine Posts & Organic Brand Awareness', 'Promote your product, service, or brand on highly-trafficked forums with genuine, engaging posts written by real people. \r\nWe develop natural, subject-relevant discussions or replies that establish credibility, and generate actual users — no spam or fake traffic.', 5000, 55, '2025-10-07 07:59:53', '2025-10-09 12:38:57'),
(41, 'Shopify Reviews', 4.00, 'Positive Saas Reviews', 'http://reviewpr.com/img/ShopifyR.png', 'Getting review or your Shopify store', 'Customers must understand that various people have purchased their product together with all customer feedback including both positive and negative evaluations. The following section presents multiple methods for obtaining reviews together with instructions to purchase affordable bulk Shopify reviews from ReviewPR.', 5000, 43, '2025-10-07 08:00:02', '2025-10-09 12:35:42')
ON DUPLICATE KEY UPDATE name = name;

-- Fix AUTO_INCREMENT for products table (from ff.sql export)
ALTER TABLE `products`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=102;

-- Add foreign key constraints
ALTER TABLE `orders`
  ADD CONSTRAINT `orders_product_fk` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

ALTER TABLE `order_status_history`
  ADD CONSTRAINT `order_history_order_fk` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `order_history_user_fk` FOREIGN KEY (`changed_by`) REFERENCES `users` (`id`) ON DELETE SET NULL;

-- Create indexes for better performance
CREATE INDEX `idx_products_category_status` ON `products` (`category`, `status`);
CREATE INDEX `idx_orders_status_created` ON `orders` (`status`, `created_at`);
CREATE INDEX `idx_orders_customer` ON `orders` (`customer_email`, `created_at`);

-- Insert some sample orders for testing
INSERT INTO `orders` (`order_number`, `customer_name`, `customer_email`, `product_id`, `product_name`, `quantity`, `amount`, `status`, `payment_status`) VALUES
('ORD-001', 'John Smith', 'john@example.com', 1, 'Google Reviews Package', 1, 49.99, 'pending', 'pending'),
('ORD-002', 'Sarah Johnson', 'sarah@example.com', 2, 'Facebook Reviews Boost', 1, 39.99, 'processing', 'paid'),
('ORD-003', 'Mike Davis', 'mike@example.com', 3, 'Trustpilot Professional', 1, 59.99, 'completed', 'paid'),
('ORD-004', 'Lisa Wilson', 'lisa@example.com', 4, 'Yelp Reputation Management', 1, 54.99, 'pending', 'pending')
ON DUPLICATE KEY UPDATE order_number = order_number;
