<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Products - ReviewPR</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Inter', Arial, sans-serif; background: #f8f9fa; }
        .container { max-width: 1200px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 2rem; border-radius: 12px; margin-bottom: 2rem; }
        .card { background: white; border-radius: 12px; padding: 2rem; margin-bottom: 2rem; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .form-group { margin-bottom: 1.5rem; }
        .form-label { display: block; font-weight: 600; margin-bottom: 0.5rem; color: #374151; }
        .form-control { width: 100%; padding: 0.75rem; border: 2px solid #e5e7eb; border-radius: 8px; font-size: 1rem; }
        .form-control:focus { outline: none; border-color: #667eea; }
        .btn { padding: 0.75rem 1.5rem; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; text-decoration: none; display: inline-block; }
        .btn-primary { background: #667eea; color: white; }
        .btn-success { background: #10b981; color: white; }
        .btn-danger { background: #ef4444; color: white; }
        .btn-secondary { background: #6b7280; color: white; }
        .btn:hover { opacity: 0.9; transform: translateY(-1px); }
        .grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 1.5rem; }
        .product-card { background: white; border-radius: 12px; padding: 1.5rem; box-shadow: 0 2px 4px rgba(0,0,0,0.1); border: 1px solid #e5e7eb; }
        .alert { padding: 1rem; border-radius: 8px; margin-bottom: 1rem; }
        .alert-success { background: #d1fae5; color: #065f46; border: 1px solid #a7f3d0; }
        .alert-error { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }
        .price { font-size: 1.5rem; font-weight: 800; color: #667eea; }
        .stock { padding: 0.25rem 0.75rem; border-radius: 20px; font-size: 0.875rem; font-weight: 600; }
        .stock.in-stock { background: #d1fae5; color: #065f46; }
        .stock.out-of-stock { background: #fee2e2; color: #991b1b; }
        textarea { resize: vertical; min-height: 100px; }
        .nav-links { margin-bottom: 2rem; }
        .nav-links a { margin-right: 1rem; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📦 Product Management System</h1>
            <p>Add, edit, and manage your review services</p>
        </div>

        <div class="nav-links">
            <a href="index.php" class="btn btn-secondary">← Back to Website</a>
            <a href="debug-products.php" class="btn btn-secondary">Debug Products</a>
            <a href="products-simple.php" class="btn btn-secondary">View API</a>
        </div>

        <?php
        // Handle form submissions
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            try {
                $servername = "localhost";
                $username = "root";
                $password = "";
                $dbname = "reviewprcom_db";

                $conn = new mysqli($servername, $username, $password, $dbname);

                if ($conn->connect_error) {
                    throw new Exception("Connection failed: " . $conn->connect_error);
                }

                if (isset($_POST['action'])) {
                    switch ($_POST['action']) {
                        case 'add':
                            $stmt = $conn->prepare("INSERT INTO products (name, price, category, description, detailed_description, stock, position, image) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                            $stmt->bind_param("sdsssiis", 
                                $_POST['name'], 
                                $_POST['price'], 
                                $_POST['category'], 
                                $_POST['description'], 
                                $_POST['detailed_description'], 
                                $_POST['stock'], 
                                $_POST['position'], 
                                $_POST['image']
                            );
                            
                            if ($stmt->execute()) {
                                echo '<div class="alert alert-success">✅ Product added successfully!</div>';
                            } else {
                                echo '<div class="alert alert-error">❌ Error adding product: ' . $stmt->error . '</div>';
                            }
                            $stmt->close();
                            break;

                        case 'update':
                            $stmt = $conn->prepare("UPDATE products SET name=?, price=?, category=?, description=?, detailed_description=?, stock=?, position=?, image=? WHERE id=?");
                            $stmt->bind_param("sdsssiiis", 
                                $_POST['name'], 
                                $_POST['price'], 
                                $_POST['category'], 
                                $_POST['description'], 
                                $_POST['detailed_description'], 
                                $_POST['stock'], 
                                $_POST['position'], 
                                $_POST['image'], 
                                $_POST['id']
                            );
                            
                            if ($stmt->execute()) {
                                echo '<div class="alert alert-success">✅ Product updated successfully!</div>';
                            } else {
                                echo '<div class="alert alert-error">❌ Error updating product: ' . $stmt->error . '</div>';
                            }
                            $stmt->close();
                            break;

                        case 'delete':
                            $stmt = $conn->prepare("DELETE FROM products WHERE id=?");
                            $stmt->bind_param("i", $_POST['id']);
                            
                            if ($stmt->execute()) {
                                echo '<div class="alert alert-success">✅ Product deleted successfully!</div>';
                            } else {
                                echo '<div class="alert alert-error">❌ Error deleting product: ' . $stmt->error . '</div>';
                            }
                            $stmt->close();
                            break;
                    }
                }

                $conn->close();
            } catch (Exception $e) {
                echo '<div class="alert alert-error">❌ Database Error: ' . $e->getMessage() . '</div>';
            }
        }
        ?>

        <!-- Add New Product Form -->
        <div class="card">
            <h2>➕ Add New Product</h2>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                
                <div class="grid">
                    <div class="form-group">
                        <label class="form-label">Product Name *</label>
                        <input type="text" name="name" class="form-control" required placeholder="e.g., Trustpilot Reviews - Premium">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Price ($) *</label>
                        <input type="number" name="price" step="0.01" class="form-control" required placeholder="9.99">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Category *</label>
                        <select name="category" class="form-control" required>
                            <option value="">Select Category</option>
                            <option value="Trustpilot">Trustpilot</option>
                            <option value="Google">Google</option>
                            <option value="G2">G2</option>
                            <option value="Capterra">Capterra</option>
                            <option value="Yelp">Yelp</option>
                            <option value="Facebook">Facebook</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Stock Quantity *</label>
                        <input type="number" name="stock" class="form-control" required value="100" min="0">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Position (Order) *</label>
                        <input type="number" name="position" class="form-control" required value="1" min="1">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Image URL</label>
                        <input type="url" name="image" class="form-control" placeholder="https://example.com/image.jpg">
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Short Description *</label>
                    <textarea name="description" class="form-control" required placeholder="Brief description of the service..."></textarea>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Detailed Description</label>
                    <textarea name="detailed_description" class="form-control" placeholder="Detailed description with features and benefits..."></textarea>
                </div>
                
                <button type="submit" class="btn btn-success">➕ Add Product</button>
            </form>
        </div>

        <!-- Existing Products -->
        <div class="card">
            <h2>📋 Existing Products</h2>
            
            <?php
            try {
                $conn = new mysqli("localhost", "root", "", "reviewprcom_db");
                
                if ($conn->connect_error) {
                    throw new Exception("Connection failed: " . $conn->connect_error);
                }

                $result = $conn->query("SELECT * FROM products ORDER BY position ASC, id ASC");
                
                if ($result->num_rows > 0) {
                    echo '<div class="grid">';
                    
                    while($product = $result->fetch_assoc()) {
                        $stockClass = $product['stock'] > 0 ? 'in-stock' : 'out-of-stock';
                        $stockText = $product['stock'] > 0 ? 'In Stock (' . $product['stock'] . ')' : 'Out of Stock';
                        
                        echo '<div class="product-card">';
                        echo '<h3>' . htmlspecialchars($product['name']) . '</h3>';
                        echo '<div class="price">$' . number_format($product['price'], 2) . '</div>';
                        echo '<p><strong>Category:</strong> ' . htmlspecialchars($product['category']) . '</p>';
                        echo '<p><strong>Position:</strong> ' . $product['position'] . '</p>';
                        echo '<p class="stock ' . $stockClass . '">' . $stockText . '</p>';
                        echo '<p>' . htmlspecialchars(substr($product['description'], 0, 100)) . '...</p>';
                        
                        echo '<div style="margin-top: 1rem;">';
                        echo '<button onclick="editProduct(' . $product['id'] . ')" class="btn btn-primary">✏️ Edit</button> ';
                        echo '<form method="POST" style="display: inline;" onsubmit="return confirm(\'Are you sure you want to delete this product?\')">';
                        echo '<input type="hidden" name="action" value="delete">';
                        echo '<input type="hidden" name="id" value="' . $product['id'] . '">';
                        echo '<button type="submit" class="btn btn-danger">🗑️ Delete</button>';
                        echo '</form>';
                        echo '</div>';
                        
                        echo '</div>';
                    }
                    
                    echo '</div>';
                } else {
                    echo '<p>No products found. Add your first product above!</p>';
                }
                
                $conn->close();
            } catch (Exception $e) {
                echo '<div class="alert alert-error">❌ Error loading products: ' . $e->getMessage() . '</div>';
            }
            ?>
        </div>
    </div>

    <script>
        function editProduct(id) {
            // For now, just alert - you can implement a modal or redirect to edit page
            alert('Edit functionality coming soon! Product ID: ' + id);
            // You could redirect to an edit page or show a modal here
        }
    </script>
</body>
</html>
