<?php
// Bulletproof checkout processor
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 0); // Don't display errors in JSON response

try {
    // Step 1: Database connection
    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "reviewprcom_db";
    
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        throw new Exception("Database connection failed: " . $conn->connect_error);
    }
    
    // Step 2: Get and validate input
    $input = file_get_contents('php://input');
    if (empty($input)) {
        throw new Exception("No input data received");
    }
    
    $data = json_decode($input, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception("Invalid JSON data: " . json_last_error_msg());
    }
    
    // Step 3: Validate required fields
    $required_fields = ['customerEmail', 'productName'];
    foreach ($required_fields as $field) {
        if (empty($data[$field])) {
            throw new Exception("Missing required field: $field");
        }
    }
    
    // Step 4: Prepare order data
    $order_id = 'ORD-' . strtoupper(substr(md5(uniqid()), 0, 8));
    $product_name = $data['productName'];
    $price = (float)($data['price'] ?? 0);
    $quantity = (int)($data['quantity'] ?? 1);
    $total = (float)($data['total'] ?? ($price * $quantity));
    $customer_email = $data['customerEmail'];
    $customer_name = $data['customerName'] ?? '';
    $review_location = $data['reviewLocation'] ?? '';
    $reviews_per_day = (int)($data['reviewsPerDay'] ?? 0);
    $promo_code = $data['promoCode'] ?? '';
    $customer_notes = $data['customerNotes'] ?? '';
    $status = 'pending';
    
    // Step 5: Insert order into database
    $sql = "INSERT INTO orders (
        order_id, product_name, price, quantity, total, 
        customer_email, customer_name, review_location, 
        reviews_per_day, promo_code, customer_notes, status
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception("Database prepare failed: " . $conn->error);
    }
    
    $stmt->bind_param("ssdidsssssss", 
        $order_id, $product_name, $price, $quantity, $total,
        $customer_email, $customer_name, $review_location,
        $reviews_per_day, $promo_code, $customer_notes, $status
    );
    
    if (!$stmt->execute()) {
        throw new Exception("Database execute failed: " . $stmt->error);
    }
    
    $stmt->close();
    $conn->close();
    
    // Step 6: Success response
    echo json_encode([
        'success' => true,
        'orderId' => $order_id,
        'message' => 'Order placed successfully!',
        'order_details' => [
            'order_id' => $order_id,
            'customer_email' => $customer_email,
            'product_name' => $product_name,
            'total' => $total
        ]
    ]);
    
} catch (Exception $e) {
    // Error response
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'debug_info' => [
            'php_version' => PHP_VERSION,
            'timestamp' => date('Y-m-d H:i:s'),
            'input_received' => !empty($input ?? ''),
            'data_parsed' => isset($data)
        ]
    ]);
}
?>
