<?php
// Simple products API without complex functions
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

try {
    // Simple database connection
    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "reviewprcom_db";

    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }

    // Get products from database
    $sql = "SELECT id, name, price, category, image, description, detailed_description, stock, position FROM products WHERE stock > 0 ORDER BY position ASC, id ASC";
    $result = $conn->query($sql);

    $products = array();

    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $products[] = [
                'id' => (int)$row['id'],
                'name' => htmlspecialchars($row['name']),
                'price' => (float)$row['price'],
                'category' => htmlspecialchars($row['category']),
                'image' => htmlspecialchars($row['image']),
                'description' => htmlspecialchars($row['description']),
                'detailed_description' => htmlspecialchars($row['detailed_description']),
                'stock' => (int)$row['stock'],
                'position' => (int)$row['position']
            ];
        }
    }

    $conn->close();

    // Return JSON
    echo json_encode($products, JSON_PRETTY_PRINT);

} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}
?>
