<?php
// Complete database reset for orders integration
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "reviewprcom_db";

try {
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    echo "<h2>Resetting Database for Order Integration...</h2>";
    
    // Force drop orders table
    $conn->query("SET FOREIGN_KEY_CHECKS = 0");
    $conn->query("DROP TABLE IF EXISTS orders");
    $conn->query("SET FOREIGN_KEY_CHECKS = 1");
    echo "<p>✅ Cleared orders table</p>";
    
    // Create fresh orders table
    $sql = "CREATE TABLE orders (
        id INT AUTO_INCREMENT PRIMARY KEY,
        order_id VARCHAR(20) NOT NULL UNIQUE,
        product_id INT DEFAULT NULL,
        product_name VARCHAR(255) NOT NULL,
        price DECIMAL(10,2) NOT NULL,
        quantity INT DEFAULT 1,
        total DECIMAL(10,2) NOT NULL,
        customer_email VARCHAR(100) NOT NULL,
        review_location TEXT DEFAULT NULL,
        promo_code VARCHAR(50) DEFAULT NULL,
        reviews_per_day INT DEFAULT NULL,
        file_name VARCHAR(255) DEFAULT NULL,
        file_link TEXT DEFAULT NULL,
        customer_notes TEXT DEFAULT NULL,
        status ENUM('pending','processing','completed','cancelled') DEFAULT 'pending',
        order_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )";
    
    if ($conn->query($sql)) {
        echo "<p>✅ Created orders table successfully</p>";
        
        // Insert test orders
        $test_orders = [
            [
                'order_id' => 'ORD-TEST001',
                'product_name' => 'Google Reviews Package',
                'price' => 49.99,
                'total' => 49.99,
                'customer_email' => 'john@example.com',
                'review_location' => 'Google My Business',
                'customer_notes' => 'Need 5 reviews for my restaurant'
            ],
            [
                'order_id' => 'ORD-TEST002', 
                'product_name' => 'Facebook Reviews Boost',
                'price' => 39.99,
                'total' => 39.99,
                'customer_email' => 'sarah@example.com',
                'review_location' => 'Facebook Business Page',
                'customer_notes' => 'Urgent - launching new product'
            ]
        ];
        
        foreach ($test_orders as $order) {
            $insert_sql = "INSERT INTO orders (order_id, product_name, price, quantity, total, customer_email, review_location, customer_notes, status) 
                          VALUES (?, ?, ?, 1, ?, ?, ?, ?, 'pending')";
            $stmt = $conn->prepare($insert_sql);
            $stmt->bind_param("ssddsss", 
                $order['order_id'],
                $order['product_name'], 
                $order['price'],
                $order['total'],
                $order['customer_email'],
                $order['review_location'],
                $order['customer_notes']
            );
            
            if ($stmt->execute()) {
                echo "<p>✅ Added test order: {$order['order_id']}</p>";
            }
        }
        
        echo "<br><h3>🎉 Database Reset Complete!</h3>";
        echo "<p>Orders table is now properly configured for admin panel integration.</p>";
        echo "<br>";
        echo "<div style='margin: 20px 0;'>";
        echo "<a href='admin_dashboard.php' style='background: #3b82f6; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; margin-right: 10px; display: inline-block;'>📊 View Admin Panel</a>";
        echo "<a href='test_order.php' style='background: #10b981; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; margin-right: 10px; display: inline-block;'>🧪 Test New Order</a>";
        echo "<a href='index.php' style='background: #6b7280; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; display: inline-block;'>🏠 Back to Website</a>";
        echo "</div>";
        
    } else {
        echo "<p>❌ Error creating orders table: " . $conn->error . "</p>";
    }
    
    $conn->close();
    
} catch (Exception $e) {
    echo "<h2>❌ Error</h2>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>

<style>
body { 
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; 
    max-width: 900px; 
    margin: 50px auto; 
    padding: 30px;
    background: #f8fafc;
}
h2, h3 { color: #1e293b; margin-bottom: 20px; }
p { margin: 12px 0; padding: 8px 0; }
ul { margin: 10px 0 10px 20px; }
li { margin: 5px 0; }
</style>
