<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Simple Order Test - ReviewPR</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50 p-8">
    <div class="max-w-md mx-auto bg-white rounded-lg shadow-lg p-6">
        <h2 class="text-2xl font-bold mb-6">Test Order Form</h2>
        
        <form id="testOrderForm">
            <div class="mb-4">
                <label class="block text-sm font-medium mb-2">Product</label>
                <select id="product" class="w-full p-3 border rounded-lg">
                    <option value="Google Reviews Package|49.99">Google Reviews Package - $49.99</option>
                    <option value="Facebook Reviews Boost|39.99">Facebook Reviews Boost - $39.99</option>
                    <option value="Trustpilot Professional|59.99">Trustpilot Professional - $59.99</option>
                    <option value="Yelp Reputation Management|54.99">Yelp Reputation Management - $54.99</option>
                </select>
            </div>
            
            <div class="mb-4">
                <label class="block text-sm font-medium mb-2">Email</label>
                <input type="email" id="email" class="w-full p-3 border rounded-lg" value="test@example.com" required>
            </div>
            
            <div class="mb-4">
                <label class="block text-sm font-medium mb-2">Review Location</label>
                <input type="text" id="location" class="w-full p-3 border rounded-lg" value="My Business Location" required>
            </div>
            
            <div class="mb-6">
                <label class="block text-sm font-medium mb-2">Notes</label>
                <textarea id="notes" class="w-full p-3 border rounded-lg" rows="3">Test order from simple form</textarea>
            </div>
            
            <button type="submit" class="w-full bg-blue-600 text-white py-3 rounded-lg hover:bg-blue-700">
                Place Test Order
            </button>
        </form>
        
        <div id="result" class="mt-6 p-4 rounded-lg hidden"></div>
        
        <div class="mt-6 text-center">
            <a href="admin_dashboard.php" class="text-blue-600 hover:underline">View Admin Panel</a> |
            <a href="index.php" class="text-blue-600 hover:underline">Back to Website</a>
        </div>
    </div>

    <script>
        document.getElementById('testOrderForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const product = document.getElementById('product').value.split('|');
            const productName = product[0];
            const price = parseFloat(product[1]);
            
            const orderData = {
                productId: 1,
                productName: productName,
                price: price,
                quantity: 1,
                total: price,
                customerEmail: document.getElementById('email').value,
                reviewLocation: document.getElementById('location').value,
                customerNotes: document.getElementById('notes').value,
                reviewsPerDay: 2,
                promoCode: '',
                fileName: '',
                fileLink: ''
            };
            
            console.log('Sending order data:', orderData);
            
            fetch('debug_order.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(orderData)
            })
            .then(response => {
                console.log('Response status:', response.status);
                return response.json();
            })
            .then(data => {
                console.log('Response data:', data);
                const resultDiv = document.getElementById('result');
                resultDiv.classList.remove('hidden');
                
                if (data.success) {
                    resultDiv.className = 'mt-6 p-4 rounded-lg bg-green-100 text-green-800';
                    resultDiv.innerHTML = `
                        <h3 class="font-bold">✅ Order Successful!</h3>
                        <p>Order ID: ${data.orderId}</p>
                        <p>Check the admin panel to see your order.</p>
                    `;
                } else {
                    resultDiv.className = 'mt-6 p-4 rounded-lg bg-red-100 text-red-800';
                    resultDiv.innerHTML = `
                        <h3 class="font-bold">❌ Order Failed</h3>
                        <p>Error: ${data.error || 'Unknown error'}</p>
                        <pre class="text-xs mt-2">${JSON.stringify(data, null, 2)}</pre>
                    `;
                }
            })
            .catch(error => {
                console.error('Fetch error:', error);
                const resultDiv = document.getElementById('result');
                resultDiv.classList.remove('hidden');
                resultDiv.className = 'mt-6 p-4 rounded-lg bg-red-100 text-red-800';
                resultDiv.innerHTML = `
                    <h3 class="font-bold">❌ Network Error</h3>
                    <p>Error: ${error.message}</p>
                    <p>Check browser console for details.</p>
                `;
            });
        });
    </script>
</body>
</html>
